-------------------------------------------------------------------------------
--
--		Random Among Edit Charts
--		
--		Author: 	Telperion
--		Date: 		2019-06-18
--		Target:		SM5.0.12+
--
-------------------------------------------------------------------------------

local circumvention = false
if circumvention then
	return Def.ActorFrame {}
end

local _FG_ = Def.ActorFrame {
	InitCommand = function(self)
	end,
	OnCommand = function(self)
		-- Random one of the four permuted edits, and set both P1 and P2 to this chosen chart.
		local stepChoices = GAMESTATE:GetCurrentSong():GetStepsByStepsType('StepsType_Dance_Single')
		local stepChoicesReduced = {}
		for _,sci in pairs(stepChoices) do
			if sci:GetDifficulty() == 'Difficulty_Edit' then
				stepChoicesReduced[#stepChoicesReduced + 1] = sci
			end
		end
		local stepSelect = math.random(#stepChoicesReduced)
		local pickedNewCharts = false
		
		for pn = 1,2 do
			if GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty() == 'Difficulty_Challenge' then
--				SCREENMAN:SystemMessage('Switching to '..whichMix..' (P'..pn..')')
				GAMESTATE:SetCurrentSteps(pn-1, stepChoicesReduced[stepSelect])
				pickedNewCharts = true
			end			
		end

		if pickedNewCharts then
			SCREENMAN:SetNewScreen("ScreenGameplay")
		end

		self:hibernate(1573)
	end
};

return _FG_
